(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2632,         75]*)
(*NotebookOutlinePosition[      3274,         97]*)
(*  CellTagsIndexPosition[      3230,         93]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(f[x_] = 475/975 + 500/975  x^2\)], "Input"],

Cell[BoxData[
    \(A = 
      Plot[f[x], {x, \(-1\), 2}, PlotPoints \[Rule] 50, 
        AspectRatio \[Rule] 1.3\/GoldenRatio, Ticks \[Rule] None, 
        PlotStyle \[Rule] {Thickness[0.004]}, 
        AxesStyle -> {Thickness[0.002]}, AxesOrigin \[Rule] {\(-0.4\), 0.3}, 
        PlotRange \[Rule] {\(-0.3\), 2}]\)], "Input"],

Cell[BoxData[
    \(B = {Line[{{0.3, f[0.3]}, {1.5, f[1.5]}, {2, 
              f[0.3] + 1.7 \((f[1.5] - f[0.3])\)/1.2}, {\(-0.5\), 
              f[0.3] - 0.8 \((f[1.5] - f[0.3])\)/1.2}}], 
        Line[{{0.3, f[0.3]}, {1.5, f[0.3]}, {1.5, f[1.5]}}], 
        Text[a1, {\(-0.26\), f[0.3]/0.8}], Text[a2, {0.8, f[1.5]}], 
        Text[a3, {1.6, 1.1}], Text[a4, {0.7, f[0.3]/1.25}]}\)], "Input"],

Cell[BoxData[
    \(Show[A, Graphics[B]]\)], "Input"],

Cell[BoxData[
    \(Display["\<tangente.eps\>", %, "\<EPS\>"]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 63, 1, 30, "Input"],
Cell[1771, 53, 327, 6, 84, "Input"],
Cell[2101, 61, 394, 6, 110, "Input"],
Cell[2498, 69, 53, 1, 30, "Input"],
Cell[2554, 72, 74, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

